<?php
/**
 * Admins
 *
 * @author El pelado
 * @UPDATE PELADITO
 * @package Generated Class
 *
 */

class Admins extends rs{

	/**
	 * Constructor
	 */
	function __construct($id=false) {

		parent::__construct();
		$this->table        = 'admins';
		$this->primary_key  = 'admin_id';

		if($id){
			$this->modulo_id = $id;
		}

	}

	function reset_session(){

		//$this->debug = true;
		if(Security::admin_id()){

			$users_list = $this->get_list(1, 1, ' AND '.db::ftquote('admin_id').' = ' . db::quote(Security::admin_id()).' ');

			if(!$users_list){
				return false;
			}

			if(db::num_rows($users_list) != 1){
				return false;
			}

			$user = db::fetch_assoc($users_list);


			if( $user['admin_activo'] == 0 ){
				Security::Logout();
				not_found("index.php?md=login");
				return false;
			}elseif ( $user['reg_deleted'] == 1 ){
				Security::Logout();
				not_found("index.php?md=login");
				return false;
			}

			$_SESSION['admin'] = $user;

		}
	}

	/**
	 * Delete All
	 *
	 * @param integer $user_id
	 * @return boolean
	 */
	public function delete_all($user_id){

		$this->table       = 'perm_users';
		$this->primary_key = 'user_id';
		$sql = "DELETE FROM " . db::ftquote($this->table) . " WHERE " . db::ftquote($this->primary_key) . " = " . db::quote($user_id);
		$rst = db::query($sql);
		//echo $sql;
		if(!$rst){
			return false;
		}
		$this->primary_key = 'perm_user_id';
		return true;
	}

	/**
	 * Delete
	 *
	 * @param integer $user_id
	 * @param integer $perm_type_id
	 * @return boolean
	 */
	public function pdelete($user_id, $perm_type_value){

		$this->table 	   = 'perm_users';
		$this->primary_key = 'perm_user_id';
		$sql = "DELETE FROM " . db::ftquote($this->table) . " WHERE ";
		$sql.= db::ftquote($this->primary_key) . " = " . db::quote($user_id) . ' AND `perm_type_value` = ' . db::quote($perm_type_value);
		$rst = db::query($sql);

		if(!$rst){
			return false;
		}
		return true;
	}
}

?>