<?php
/**
 * sitemap
 *
 * @author Pealado
 * @package Canal Mercantil
 */

/**
 * sitemap Class
 *
 * @package Canal Mercantil
 */

class sitemap extends rs{

	public $lastmod;
	public $changefreg;
	public $priority = 0.8;

	private $sitemap;

	public function __construct($freg = 0) {

		parent::__construct();

		$this->lastomd();
		$this->changefreg($freg);

	}

	public function changefreg($freg){

		$changefreg = array();

		$always 	= "always"; 	// (siempre)
		$hourly 	= "hourly"; 	// (cada hora)
		$daily 		= "daily"; 		// (diariamente)
		$weekly 	= "weekly"; 	// (semanalmente)
		$monthly 	= "monthly"; 	// (mensualmente)
		$yearly 	= "yearly"; 	// (anualmente)
		$never 		= "never"; 		// (nunca)

		$changefreg[0] = $always;
		$changefreg[1] = $hourly;
		$changefreg[2] = $daily;
		$changefreg[3] = $weekly;
		$changefreg[4] = $monthly;
		$changefreg[5] = $yearly;
		$changefreg[6] = $never;

		$this->changefreg = $changefreg[$freg];

	}

	public function lastomd(){
		$this->lastmod = date_format(date_create(),"Y-m-d");
	}

	public function parse_sitemap(){

		$urls = $this->url_categ();
		$urls.= $this->url_productos();
		$this->urlset($urls);

		if(file_put_contents($_SERVER['DOCUMENT_ROOT'].'/sitemap.xml',$this->sitemap,LOCK_EX)){

			echo '<script>parent.document.getElementById("exe").style["display"] = "block";</script>';
			echo '<script>parent.document.getElementById("genera_map").style["display"] = "none";</script>';
			echo '<script>parent.document.getElementById("progressbar_bar").style["display"] = "none";</script>';
			echo '<div class="alert alert-success">SITEMAP GENERADO CORRECTAMENTE</div>';

		}else{

			echo '<script>parent.document.getElementById("exe").style["display"] = "block";</script>';
			echo '<script>parent.document.getElementById("progressbar_bar").style["display"] = "none";</script>';
			echo '<div class="alert alert-error">SERVER ERROR</div>';
		}
	}

	public function urlset($urls){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile("urlset_sitemap.tpl.html");
		$tpl->setVariable('base_ref',BASE_REF);
		$tpl->setVariable('content_url',$urls);
		$this->sitemap = $tpl->get();
	}

	public function url_productos(){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile("url_sitemap.tpl.html");

		$productos = new Productos();

		$where = ' AND `productos`.`producto_activo` AND `productos`.`producto_aprobado` AND NOT `mayoristas`.`reg_deleted` ';
		$where.= ' AND `mayoristas`.`mayorista_activo` AND `categorias`.`categ_activa` AND NOT `categorias`.`reg_deleted` ';

		$productos->pivot_fields = array("producto_id" => "ID","producto_nombre");

		$productos->pivot_tables = array(

				1 => array(
						"table" => "categorias",
						"fields"=> array("categ_nombre"),
						"link_a"=> "categoria_id",
						"link_b"=> "categ_id"),

				2 => array(
						"table" => "mayoristas",
						"fields"=> array("mayorista_raz_social"),
						"link_a"=> "mayorista_id",
						"link_b"=> "mayorista_id"),

				3 => array(
						"table"    => "producto_precios",
						"fields"   => array("precio_precio","moneda_id"),
						"link_a"   => "producto_id",
						"link_b"   => "producto_id"));

		$productos_list = $productos->get_list(0,1,$where,'',true);

		if($productos_list){

			$e=0;

			while($row = db::fetch_assoc($productos_list)){

				$tpl->setCurrentBlock('url_productos');
					$tpl->setVariable('producto_nombre',url_friendly($row['producto_nombre']));
					$tpl->setVariable('producto_id',    $row['ID']);
					$tpl->setVariable('base_ref',   	BASE_REF);
					$tpl->setVariable('lastmod',    	$this->lastmod);
					$tpl->setVariable('changefreg', 	$this->changefreg);
					$tpl->setVariable('priority',   	$this->priority);
				$tpl->parse('url_productos');

				echo "<script>parent.document.getElementById('progressbar').style['width'] = '".($e/10)."%';</script>";

				$e++;
			}

			return $tpl->get("url_productos");
		}

	}

	public function url_categ_childrens($parent_id){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile("url_sitemap.tpl.html");

		$categorias = new Categorias();
		//$categorias->debug=true;
		$hijos = array();

		if($parent_id != 0){

			$childs = $categorias->get_list(0,1," AND ".db::ftquote("categ_hija_de")." = ".db::quote($parent_id)." AND `categ_activa` "," ".db::ftquote('categ_nombre'));

			if($childs){

				while ($categ_child = db::fetch_array($childs)){
					$hijos[] = array($categ_child['categ_id'],$categ_child['categ_nombre']);
				}

				if($hijos){

					foreach ($hijos AS $key => $names){

						$tpl->setCurrentBlock("url_childrens");
							$tpl->setVariable('categ_nom',  url_friendly($names[1]));
							$tpl->setVariable('categ_id',   $names[0]);
							$tpl->setVariable('base_ref',   BASE_REF);
							$tpl->setVariable('lastmod',    $this->lastmod);
							$tpl->setVariable('changefreg', $this->changefreg);
							$tpl->setVariable('priority',   $this->priority);
							$tpl->setVariable('childrens',  $this->url_categ_childrens($names[0]));
						$tpl->parse('url_childrens');
					}
				}

				return $tpl->get('url_childrens');

			}else{
				return false;
			}
		}
	}

	public function url_categ(){


		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile("url_sitemap.tpl.html");

		$categorias = new Categorias();
		//$categorias->debug=true;
		$categ_list = $categorias->get_list(0,1," AND `categ_hija_de` = 0 AND `categ_activa` "," ".db::ftquote('categ_nombre'));

		if($categ_list){

			$e=0;

			while ($categ = db::fetch_array($categ_list)){

				$tpl->setCurrentBlock('url');
					$tpl->setVariable('categ_nom',  url_friendly($categ['categ_nombre']));
					$tpl->setVariable('categ_id',   $categ['categ_id']);
					$tpl->setVariable('base_ref',   BASE_REF);
					$tpl->setVariable('lastmod',    $this->lastmod);
					$tpl->setVariable('changefreg', $this->changefreg);
					$tpl->setVariable('priority',   $this->priority);

					if($this->url_categ_childrens($categ['categ_id'])){
						$tpl->setVariable('childrens',  $this->url_categ_childrens($categ['categ_id']));
					}
				$tpl->parse('url');

				echo "<script>parent.document.getElementById('progressbar').style['width'] = '".($e/10)."%';</script>";

				$e++;
			}

			return $tpl->get('url');
		}
	}

}

?>