<?php
/**
 * Database Class
 *
 * Update Pelado Mysli
 */

class db{

	/**
	 *
	 */
	public static function connectdb(){
		global $db;

		if(!$db = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME)){
			return false;
		}

		if(mysqli_connect_errno()){
			die(mysqli_connect_error());
		}

		mysqli_query($db,"SET NAMES utf8");

		mysqli_set_charset($db,'utf8');

		return true;

	}

	/**
	 * Disconnect MySQL
	 * @return boolean
	 */
	public static function disconnectdb(){
		global $db;

		mysqli_close($db);

		return true;

	}
	/**
	 * Num Rows
	 *
	 * @return integer
	 */
	public static function num_rows($rst){
		global $db;
		return mysqli_num_rows($rst);

	}

	/**
	 * Affected Rows
	 *
	 * @return integer
	 */
	public static function affected_rows(){
		global $db;
		return mysqli_affected_rows($db);

	}

	/**
	 * Last Inserted Id
	 *
	 * @return integer
	 */
	public static function insert_id(){
		global $db;
		return mysqli_insert_id($db);
	}

	public static function fetch_field_direct($rst){
		global $db;
		return mysqli_fetch_field_direct($rst);
	}

	/**
	 * Fetch Assoc
	 *
	 * @return array
	 */
	public static function fetch_assoc($rst){
		global $db;
		return mysqli_fetch_assoc($rst);

	}

	/**
	 * Fetch Object
	 * @param $rst
	 */
	public static function fetch_object($rst){
		global $db;
		return mysqli_fetch_object($rst);
	}

	/**
	 * Fetch Aarray
	 *
	 * @return array
	 */
	public static function fetch_array($rst){
		global $db;
		return mysqli_fetch_array($rst);
	}

	/**
	 * Quote String
	 *
	 * @param string $value
	 * @return string
	 */
	public static function quote($value){
		global $db;

		if(get_magic_quotes_gpc()){
			$value = stripslashes($value);
		}

		$value = "'" . mysqli_real_escape_string($db,$value) . "'";

		return $value;

	}

	/**
	 * Field Or Table Quote String
	 *
	 * @param string $value
	 * @return string
	 */
	public static function ftquote($value){
		global $db;

		if(get_magic_quotes_gpc()){
			$value = stripslashes($value);
		}

		$value = "`" . mysqli_real_escape_string($db,$value) . "`";

		return $value;

	}

	/**
	 * Run MySQL Query
	 *
	 * @param string $sql
	 * @return mysql_resource or false
	 */
	public static function query($sql){
		global $db;

		$rst = mysqli_query($db,$sql);

		if(!$rst && !DEBUG_DB){

			$file = BASE_PATH . "/logs/sql_errors.log";

			$size = filesize($file);

			if($size > 500000){
				unlink($file);
			}

			if(DEBUG_DB){
				send_email("Error:".$this->error_sql());
			}

			error_log(date("Y-m-d H:i:s (T)") . ' - ' . "Error:".mysqli_sqlstate($db).'--'.$sql . ";\n", 3, BASE_PATH . "/logs/sql_errors.log");
			return false;
		}
		//echo $rst;
		return $rst;
	}

	/**
	 * Explain
	 * @param string $sql
	 */
	public static function explain($sql){

		if(substr($sql, 0, 6) != 'SELECT'){
			return false;
		}

		$rst = db::query('EXPLAIN ' . $sql);

		if(!$rst){
			return false;
		}

		if(db::num_rows($rst) == 0){
			return false;
		}

		while($row = db::fetch_assoc($rst)){

			if(preg_match("/temporary/i", $row['Extra'])){
			    error_log($sql . "\n", 3, BASE_PATH . "/logs/sql_opt.log");
			    return true;
			}

		}

		return true;

	}

	public static function error_sql(){
		global $db;
		return mysqli_error($db);
	}
}

?>