<?php
/**
 * General Functions
 *
 * @author Peladito
 * @package publicartel
 */

	function remove_error(){
		$file = BASE_PATH . "/logs/exceptions.log";
		$size = filesize($file);

		if($size > 5000000){
			unlink($file);
		}
	}

	function log_error( $num, $str, $file, $line, $context = null ){

		remove_error();
		switch ($num){
			case E_WARNING:
			case E_CORE_ERROR:
			case E_CORE_WARNING:
			case E_COMPILE_ERROR:
			case E_COMPILE_WARNING:
			case E_USER_ERROR:
			case E_USER_WARNING:
			case E_USER_NOTICE:
			case E_RECOVERABLE_ERROR:
			case E_NOTICE: return ;
			break;
		}

		log_exception( new ErrorException( $str, 0, $num, $file, $line ) );
	}

	function log_exception( $e ){

		remove_error();

		if ( DEBUG_LOCAL ){

			print "<div style='text-align: center;'>";
			print "<h2 style='color: rgb(190, 50, 50);'>Exception Occured:</h2>";
			print "<table style='width: 800px; display: inline-block;'>";
			print "<tr style='background-color:rgb(230,230,230);'><th style='width: 80px;'>Type</th><td>" . get_class( $e ) . "</td></tr>";
			print "<tr style='background-color:rgb(240,240,240);'><th>Message</th><td>{$e->getMessage()}</td></tr>";
			print "<tr style='background-color:rgb(240,240,240);'><th>PHP</th><td>".PHP_VERSION." (" . PHP_OS . ")</td></tr>";
			print "<tr style='background-color:rgb(230,230,230);'><th>File</th><td>{$e->getFile()}</td></tr>";
			print "<tr style='background-color:rgb(240,240,240);'><th>Line</th><td>{$e->getLine()}</td></tr>";
			print "</table></div>";
			exit();

		}else{

			$message = "Type: " . get_class( $e ) . "Message: {$e->getMessage()} " . PHP_EOL . "<br>File: {$e->getFile()}" . PHP_EOL . "Line: {$e->getLine()}" . PHP_EOL . "-----------------------------------" . PHP_EOL;
			file_put_contents( BASE_PATH . "/logs/exceptions.log", $message . PHP_EOL, FILE_APPEND );
			send_email($message,get_class( $e ));
			print "<h2 style='color: rgb(190, 50, 50);'>Exception Aborting</h2>";

			exit();
		}

		exit();
	}

	function check_for_fatal(){

		remove_error();

		$error = error_get_last();
		if ( $error["type"] === E_ERROR ){
			log_error( $error["type"], $error["message"], $error["file"], $error["line"] );
		}
	}

	function send_email($msj,$subject='fatal handler'){
		$mail = new PHPMailer();
		$mail->isSMTP();
		$mail->SetLanguage("es");
		$mail->IsHTML(true);
		$mail->CharSet = 'utf-8';
		$mail->Body    = $msj;
		$mail->Subject = "fatal handler";
		$mail->From    = 'no-replay@'.$_SERVER['SERVER_NAME'].'';
		$mail->FromName= "IT - ".$_SERVER['SERVER_NAME']."";
		$mail->AddAddress('julio@3tipos.com','IT');
		$mail->Send();
	}

	function format_error( $errno, $errstr, $errfile, $errline ) {
		//$trace = print_r( debug_backtrace( false ), true );

		$content = "
		<table>
			<thead>
				<tr>
					<th>Item</th>
					<th>Description</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>Error</td>
					<td>$errstr</td>
				</tr>
				<tr>
					<td>Errno</td>
					<td>$errno</td>
				</tr>
				<tr>
					<td>File</td>
					<td>$errfile</td>
				</tr>
				<tr>
					<td>Line</td>
					<td>$errline</td>
				</tr>
			</tbody>
		</table>";

		return $content;
	}

	/**
	 * User Error Handler
	 *
	 * @param integer $errno
	 * @param string $errmsg
	 * @param string $filename
	 * @param integer $linenum
	 * @param array $vars
	 */
	function userErrorHandler($errno, $errmsg, $filename, $linenum, $vars){

    	$dt = date("Y-m-d H:i:s (T)");

		if (PHP_VERSION < 5){
			define('E_STRICT', 0);
		}

	    $errortype = array (
	                E_ERROR              => 'Error',
	                E_WARNING            => 'Warning',
	                E_PARSE              => 'Parsing Error',
	                E_NOTICE             => 'Notice',
	                E_CORE_ERROR         => 'Error',
	                E_CORE_WARNING       => 'Warning',
	                E_COMPILE_ERROR      => 'Compile Error',
	                E_COMPILE_WARNING    => 'Compile Warning',
	                E_USER_ERROR         => 'User Error',
	                E_USER_WARNING       => 'User Warning',
	                E_USER_NOTICE        => 'User Notice',
	                E_STRICT             => 'Runtime Notice',
	                E_RECOVERABLE_ERROR  => 'Catchable Fatal Error');

		$err = $dt . ' ' . $errortype[$errno] . ' ' . $errmsg . ' in ' . $filename . ' at line ' . $linenum . "\n" ;

		$file = BASE_PATH . "/logs/php_errors.log";

		$size = filesize($file);
		//echo $size.'<br>';

		if($size > 5000000){
			unlink($file);
		}

		error_log($err, 3, BASE_PATH . "/logs/php_errors.log");
	}

	/**
	 * Send Request
	 */
	function SendRequest($url, $data, $username = '', $password = ''){

		$ch = curl_init();

		$data = http_build_query($data);

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		if($username != '' && $password != ''){
			curl_setopt($ch, CURLOPT_USERPWD, $username . ':' . $password);
		}

		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

		$ret = curl_exec($ch);

		if(curl_error($ch) != ''){
			echo curl_error($ch) . "\n\n";
			return false;
		}

		curl_close($ch);

		return $ret;

	}

	/**
	 * Get POST var
	 *
	 * @param string $name
	 * @param string $default
	 * @return mixed
	 */
	function _post($name, $default = ''){

		if(!isset($_POST[$name]) || $_POST[$name] == ''){

			$default = trim($default);
			return $default;

		}else {

			if(is_array($_POST[$name])){

				$data = array_map('trim', $_POST[$name]);
				return $data;

			}else{

				$name = trim($_POST[$name]);
				return $name;
			}
		}
	}

	/**
	 * Get GET var
	 *
	 * @param string $name
	 * @param string $default
	 * @return mixed
	 */
	function _get($name, $default = ''){

		if(!isset($_GET[$name]) || $_GET[$name] == ''){

			$default = trim($default);
			return $default;

		}else {

			if(is_array($_GET[$name])){

				$data = array_map('trim', $_GET[$name]);
				return $data;

			}else{

				$name = trim($_GET[$name]);
				return $name;
			}
		}
	}

	/**
	 * Get REQUEST var
	 *
	 * @param string $name
	 * @param string $default
	 * @return mixed
	 */
	function _request($name, $default = ''){

		if(!isset($_REQUEST[$name]) || $_REQUEST[$name] == ''){

			$default = trim($default);
			return $default;

		}else {

			if(is_array($_REQUEST[$name])){

				$data = array_map('trim', $_REQUEST[$name]);
				return $data;

			}else{

				$name = trim($_REQUEST[$name]);
				return $name;
			}
		}
	}

	/**
	 * Get SESSION var
	 *
	 * @param string $name
	 * @param string $default
	 * @return mixed
	 */
	function _session($name, $default = ''){

		if(!isset($_SESSION[$name]) || $_SESSION[$name] == ''){

			$default = trim($default);
			return $default;

		}else{

			if(is_array($_SESSION[$name])){

				$data = array_map('trim', $_SESSION[$name]);
				return $data;

			}else{

				$name = trim($_SESSION[$name]);
				return $name;
			}
		}
	}

	/**
	 * Check Number
	 *
	 * @param string $value
	 * @param integer $min
	 * @return boolean
	 */
	function checkNumber($value, $min = 0){

		if(!preg_match("#^[+-]?[0-9]*\.?[0-9]+$#", $value)){
			return false;
		}else {
			if(strlen($value) < $min){
				return false;
			}else {
				return true;
			}
		}
	}

	/**
	 * Check Lenght
	 *
	 * @param string $value
	 * @param integer $min
	 * @param integer $max
	 * @return boolean
	 */
	function checkLenght($value, $min = 0, $max = 0){

		if(strlen($value) < $min){
			return false;
		}

		if($max != 0 && strlen($value) > $max){
			return false;
		}

		return true;

	}

	/**
	 * Check Email
	 *
	 * @param string $email
	 * @return boolean
	 */
	function checkEmail($email){

		if( preg_match("#^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$#", $email)){

			$arroba = explode("@",$email);
			$dnsrr  = array_pop($arroba);

			if(checkdnsrr($dnsrr,"MX")){
				return true;
			}else {
				return false;
			}

		}else{
			return false;
		}
	}

	function checkEmailAndDomain($email){
		$exp = "/^(.*)@(.*)$/";
		preg_match($exp, $email, $matches);

		if (!empty($matches[1]) and (!filter_var($email, FILTER_VALIDATE_EMAIL))){
			return false;
		}

		$dnsrr = idn_to_ascii(utf8_encode($matches[2]));
		return (checkdnsrr($dnsrr,'MX'));
	}

	function checkRut($numero){
		$digitos = strrev($numero);
		$serie =  array(2,3,4,5,6,7,8,9);
		$total= '';
		$r=0;
		for($i=0; $i<=strlen($numero);$i++){
			$ret = substr($digitos, $i,1);
			if($ret!=''){
				$total+= $ret * $serie[$r];
				$r++;
				if($r>7){
					$r=0;
				}
			}
		}
		$resto = $total % 11;
		$sub = 11 - $resto;
		if($sub == 11){
			$sub = 0;
		}
		if($sub == 10){
			$sub = 'k';
		}
		return $sub;
	}

	function Cache(){
		header ("Expires: Thu, 27 Mar 1900 23:59:00 GMT");
		header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
		header ("Cache-Control: no-cache, must-revalidate");
		header ("Pragma: no-cache");
	}

	function char_illegal($original = "") {
		$illegalchars = array ('à','á','ù','"', '\'', '{', '}', '|', '\\', '^', '~', '[', ']',
		                       '`', '#', '\/', ';', '?', ':', '@', '=', '&', '$', '%', '*',
							   'é','è','Û','ü','ä','ò','ó','ñ','ú','ì','í','ç','ć'
		);
		$original = strtolower($original);
		$temp = str_replace($illegalchars, "", $original);
		$temp = str_replace(" ", "_", $temp);
		$temp = strtolower($temp);
		return $temp;
	}

	function getIco($activo){
		switch ($activo){
			case 1: return "true";
			break;

			case 0: return "false";
			break;
		}
	}

	function select($post,$campo,$tipo=false){
		if(_request($post) == $campo){
			if($tipo){
				return "checked=checked";
			}else{
			    return "selected=selected";
			}
		}
	}

	/**
	 * Recotar palabras por espacios
	 * @param $texto
	 * @param $length
	 */
	function recort($texto,$length=""){

		($length == "")? $length = 20 : $length = $length;
		$texto = explode(" ",$texto);
		foreach ($texto as $text){
		  if(mb_strwidth($text)>$length){
		  	$ret = mb_strcut($text,0,$length);
		  }else{
		  	$ret = $text;
		  }
		  $retorno[] = $ret;
		}
		$retor = implode(" ",$retorno);
		return $retor;
	}

	/**
	 * Recortar texto por caracteres, acepta html
	 * @param $texto
	 * @param $longitud
	 *
	 */
	function recortar_texto($texto, $longitud = 180) {

		if((mb_strlen($texto) > $longitud)) {
		    $pos_espacios = mb_strpos($texto, ' ', $longitud) - 1;
		    if($pos_espacios > 0) {
		        $caracteres = count_chars(mb_substr($texto, 0, ($pos_espacios + 1)), 1);
		        if ($caracteres[ord('<')] > $caracteres[ord('>')]) {
		            $pos_espacios = mb_strpos($texto, ">", $pos_espacios) - 1;
		        }
		        $texto = mb_substr($texto, 0, ($pos_espacios + 1)).'...';
		    }
		    if(preg_match_all("|(<([\w]+)[^>]*>)|", $texto, $buffer)) {
		        if(!empty($buffer[1])) {
		            preg_match_all("|</([a-zA-Z]+)>|", $texto, $buffer2);
		            if(count($buffer[2]) != count($buffer2[1])) {
		                $cierrotags = array_diff($buffer[2], $buffer2[1]);
		                $cierrotags = array_reverse($cierrotags);
		                foreach($cierrotags as $tag) {
		                        $texto .= '</'.$tag.'>';
		                }
		            }
		        }
		    }

		}
		return $texto;
	}

	function get_file_thumb($file_name,$w=60,$h=60){
	   $file = "";

	   if(file_exists(BASE_PATH.$file_name)){
	   		$file .= '<img src="'.$file_name.'"/>';
	   }else{
	   	 	$file .= '<img src="thumb.php?src=/img/header/not_found.jpg&w='.$w.'&h='.$h.'" />';
	   }

	   return $file;
	}

	/**
	 *
	 * Check URL ...
	 * @param $url
	 */
	function ValidarURL($url){
		return preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $url);
	}

	/**
	 * 404 Not Found
	 *
	 * @param string $redirect URL
	 */
	function not_found($redirect = ''){

		header("HTTP/1.0 404 Not Found");

		if($redirect != ''){
			header("Location: " . $redirect);
		}

		die();

	}

	/**
	 *
	 * Enter description here ...
	 * @param unknown_type $fecha
	 */
	function get_fecha($fecha){
			$lenguage = 'es_ES.UTF-8';
			putenv("LANG=$lenguage");
			date_default_timezone_set('America/Montevideo');
			setlocale(LC_ALL,$lenguage);
			$ret = ucfirst(strftime("%d de %B de %Y",strtotime($fecha)));

			return $ret;
	}

	/**
	 *
	 * Enter description here ...
	 * @param unknown_type $text
	 * @param unknown_type $cant
	 */
	function url_friendly($string){
		$string = preg_replace("`\[.*\]`U","",$string);
		$string = preg_replace('`&(amp;)?#?[a-z0-9]+;`i','-',$string);
		$string = htmlentities($string, ENT_COMPAT, 'utf-8');
		$string = preg_replace( "`&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);`i","\\1", $string );
		$string = preg_replace( array("`[^a-z0-9]`i","`[-]+`") , "_", $string);
		return strtolower(trim($string, '-'));
	}

	function date_compare($date1,$date2){
	  date_default_timezone_set('UTC');

      if (preg_match("/[0-9]{1,2}\/[0-9]{1,2}\/([0-9][0-9]){1,2}/",$date1)){

              list($dia1,$mes1,$año1)=split("/",$date1);
      }

      if (preg_match("/[0-9]{1,2}-[0-9]{1,2}-([0-9][0-9]){1,2}/",$date1)){

              list($dia1,$mes1,$año1)=split("-",$date1);
       }

      if (preg_match("/[0-9]{1,2}\/[0-9]{1,2}\/([0-9][0-9]){1,2}/",$date2)){

              list($dia2,$mes2,$año2)=split("/",$date2);
      }

      if (preg_match("/[0-9]{1,2}-[0-9]{1,2}-([0-9][0-9]){1,2}/",$date2)){

              list($dia2,$mes2,$año2)=split("-",$date2);
      }
      /*echo mktime($mes1,$dia1,$año1);
      echo '<br>';
      echo mktime($mes2,$dia2,$año2);*/

      $dif = mktime($mes1,$dia1,$año1) - mktime($mes2,$dia2,$año2);
      return $dif;
	}

	/**
	 * Recotar texto y poner links
	 *
	 * @param  $text
	 * @param  $cant
	 * @param  $href
	 * @param  $id
	 * @param  $class
	 */
    function recort_text($text,$cant=50,$href=false,$id=false,$class=false,$rel=false){
    	$texto = explode(" ", $text);
    	$total = count($texto);
    	$i = 1;
        if($total > $cant){
	    	  foreach ($texto AS $t){
	    		if($i < $cant){
	    			$ret[] = $t;
	    		}
	    		$i++;
	    	  }
	    	  $retorno = implode(" ",$ret);
	    	  if($href){
	    	  	return $retorno.'... <a href="'.$href.'" id="'.$id.'" rel="'.$rel.'" class="'.$class.'">más >></a>';
	    	  }else{
	    	  	return $retorno.'...';
	    	  }
       }else{
    	  return $text;
    	}
    }

    /**
	 * 0 => competa - 1 => hora - 2 => fecha
	 * @param  $fecha la fecha/hora pasada
	 * @param  $hours opcional int
	 * @return string
	 */
	function format_date($fecha,$hours){
		if($hours != ""){
			$hours = (int) $hours;
		}else{
			$hours = 2;
		}

		$new_date = new DateTime($fecha);

		switch ($hours){
			/*
			 * competa
			 */
			case 0:  $return = $new_date->format("d/m/Y H:i:s");
				break;

			/*
			* hora
			*/
			case 1:  $return = $new_date->format("H:i");
				break;

			/*
			 * fecha
			 */
			case 2:  $return = $new_date->format("d/m/Y");
				break;
		}

		return $return;
	}

	function format_date_time($fecha_hora,$date=false,$hours=false){
		$new_date = new DateTime($fecha_hora);
		if($date){
			if($fecha_hora == '0000-00-00'){
				return 'Sin definir';
			}else{
				return $new_date->format("d/m/Y");
			}
		}
		if($hours){
			if($fecha_hora == '0000-00-00 00:00:00'){
				return 'Sin definir';
			}else{
				return $new_date->format("H:i");
			}
		}
		return $new_date->format("d/m/Y H:i:s");
	}

    function checked($id){
    	$return = false;
    	if($id == 1){
    		$return = "checked='checked'";
    	}
    	return $return;
    }

    function parse_estado($id,$text){
    	$return = false;
    	return $text[$id];
    }

    /**
     * Estado de un boleano, devuelte el texto pasado como un array o por defecto el de la funcion
     * @param @int  $id
     * @param @string $text
     * @return <string>
     */
	function combos_numericos($post,$variable_post,$cant=100,$placeholder="Seleccione",$function=false,$disabled=false){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_select.tpl.html');

		$tpl->setCurrentBlock("combo_default");

		if(is_array($cant)){

			for ($i = $cant[0] ; $i <= $cant[1]; $i++){

				$tpl->setCurrentBlock("row");

					$tpl->setVariable('value', $i);
					$tpl->setVariable('key',   $i);

					if($i == $post){
						$tpl->setVariable("selected","selected");
					}

				$tpl->parse('row');
			}

		}else{

			for ($i = 1 ; $i <= $cant; $i++){

				$tpl->setCurrentBlock("row");

					$tpl->setVariable('value', $i);
					$tpl->setVariable('key',   $i);
					if($i == $post){
						$tpl->setVariable("selected","selected");
					}

				$tpl->parse('row');
			}
		}

		if($function){
			$tpl->setVariable("function", "onchange = ".$function."");
		}

		if($disabled){
			$tpl->setVariable('disabled', "disabled='disabled'");
		}

		$tpl->setVariable('variable_post', $variable_post);
		$tpl->setVariable('placeholder', (!$placeholder)? 'Seleccione' : $placeholder);

		$tpl->parse("combo_default");

		$module = $tpl->get();

		return  $module;
	}

	/**
	 * No ando inspirado para implementarlo en el otro combo todo junto (get_combos de RS),
	 * este arma combos en base @param $variable_post, que debe ser un array
	 */
	function combos_genericos($post,$variable_post,$function=false,$placeholder="Seleccione",$disabled=false){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_select.tpl.html');

		$string = $variable_post[0];

		$tpl->setCurrentBlock("combo_default");

		foreach ($variable_post[1] AS $clave => $valor) {

			$tpl->setCurrentBlock("row");
				$tpl->setVariable('value', $valor);
				$tpl->setVariable('key',   $clave);

				if($clave == $post){
					$tpl->setVariable("selected",'selected="selected"');
				}
			$tpl->parse('row');
		}

		$placeholder = ($placeholder)? $placeholder : $string;

		$tpl->setVariable('variable_post', $string);
		$tpl->setVariable('placeholder',   $placeholder);

		if($function){
			$tpl->setVariable("function", "onchange = ".$function."");
		}

		if($disabled){
			$tpl->setVariable('disabled', 'disabled="disabled"');
		}

		$tpl->parse("combo_default");

		$module = $tpl->get();

		return  $module;

	}

	/**
     * Eliminar elementos de un array multi dimensional
     *
     * @param  $array - padre
     * @param  $keys  - eliminar
     */
    function array_remove_keys($array, $keys = array()) {

	    if(empty($array) || (! is_array($array))) {
	        return $array;
	    }

	    if(is_string($keys)) {
	        $keys = explode(',', $keys);
	    }

	    if(! is_array($keys)) {
	        return $array;
	    }

	    $assocKeys = array();
	    foreach($keys as $key) {
	        $assocKeys[$key] = true;
	    }

	    return array_diff_key($array, $assocKeys);
    }

	function check_permisos($file){
		if(!is_readable($file)){
			return false;
		}

		if(!is_writable($file)){
			return false;
		}

		return true;
	}

	function create_folder($path){
		if(!mkdir($path, 0777, true)){
			return false;
		}

		if(!chmod($path,  0777)){
			return false;
		}

		return true;

	}

	function folder_read($path){
		if(!is_dir($path)){
			if(!create_folder($path)){
				return false;
			}
		}
		return true;

	}

	function check_ext($ext,$file){
		$fileTypes  = str_replace('*','',$ext);
		$typesArray = explode(";",$fileTypes);
		$fileParts  = strrchr($file,".");
		if (in_array($fileParts,$typesArray)) {
			return true;
		} else {
			return false;
		}
	}

	function rip_tags($string) {

		$string = preg_replace ('/<[^>]*>/', ' ', $string);

		$string = str_replace("\r", '', $string);    // --- replace with empty space
		$string = str_replace("\n", ' ', $string);   // --- replace with space
		$string = str_replace("\t", ' ', $string);   // --- replace with space

		$string = trim(preg_replace('/ {2,}/', ' ', $string));

		return $string;
	}

	function message_flush(){
		mb_http_output("UTF-8");
		ob_start("mb_output_handler");
		echo str_pad('',4096);
	}

	function flush_buffers($text){
		echo nl2br($text);
		ob_end_flush();
		ob_flush();
		flush();
		ob_start();
		Sleep(1);
	}

	function cmp($a, $b){
		if ($a == $b) {return 0;}
		return ($a < $b) ? -1 : 1;
	}

	function mkDirFix ($path,$FTP_USER,$FTP_PASS) {

		$path = explode("/",$path);
		$conn_id = @ftp_connect("localhost");
		if(!$conn_id) {
			return false;
		}
		if (@ftp_login($conn_id, $FTP_USER, $FTP_PASS)) {

			foreach ($path as $dir) {
				if(!$dir) {
					continue;
				}
				$currPath.="/".trim($dir);
				if(!@ftp_chdir($conn_id,$currPath)) {
					if(!@ftp_mkdir($conn_id,$currPath)) {
						@ftp_close($conn_id);
						return false;
					}
					@ftp_chmod($conn_id,0777,$currPath);
				}
			}
		}
		@ftp_close($conn_id);
		return $currPath;
	}

	function _filename($file){

		$fileName = $file;
		$pos_dot = strrpos($fileName, "/");
		$name = ($pos_dot !== false) ? substr($fileName, $pos_dot+1) : null;

		return $name;
	}

	function mobile(){

		$hua=$_SERVER['HTTP_USER_AGENT'];
		if(preg_match('/pocket|psp|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino|
				iris|kindle|lge|maemo|midp|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|
				android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|smartphone)/i',strtolower($hua)))$m=true;
		if(strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml')>0||
				((isset($_SERVER['HTTP_X_WAP_PROFILE'])||isset($_SERVER['HTTP_PROFILE']))))$m=true;

		$mua=strtolower(substr($hua,0,4));
		$ma = array('w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac','blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
				'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-','maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-','newt','noki',
				'oper','palm','pana','pant','phil','play','port','prox','qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar','sie-','siem','smal',
				'smar','sony','sph-','symb','t-mo','teli','tim-','tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp','wapr','webc','winw','xda','xda-');
		if(in_array($mua,$ma))$m=true;
		if(strpos(strtolower(@$_SERVER['ALL_HTTP']),'OperaMini')>0)$m=true;
		if(strpos(strtolower($hua),'windows')>0&&strpos(strtolower($hua),'IEMobile')<=0)$m=false;
		return $m;
	}

	/**
	 *
	 *
	 */
	function isMobile() {
		return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
	}

	function isMobile_2() {
		return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
	}

	/**
	 *  $ismobile = check_user_agent('mobile');
	 *
	 */
	function check_user_agent ( $type = NULL ) {
		$user_agent = strtolower ( $_SERVER['HTTP_USER_AGENT'] );
		if ( $type == 'bot' ) {
			// matches popular bots
			if ( preg_match ( "/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent ) ) {
				return true;
				// watchmouse|pingdom\.com are "uptime services"
			}
		} else if ( $type == 'browser' ) {
			// matches core browser types
			if ( preg_match ( "/mozilla\/|opera\//", $user_agent ) ) {
				return true;
			}
		} else if ( $type == 'mobile' ) {
			// matches popular mobile devices that have small screens and/or touch inputs
			// mobile devices have regional trends; some of these will have varying popularity in Europe, Asia, and America
			// detailed demographics are unknown, and South America, the Pacific Islands, and Africa trends might not be represented, here
			if ( preg_match ( "/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent ) ) {
				// these are the most common
				return true;
			} else if ( preg_match ( "/mobile|pda;|avantgo|eudoraweb|minimo|netfront|brew|teleca|lg;|lge |wap;| wap /", $user_agent ) ) {
				// these are less common, and might not be worth checking
				return true;
			}
		}
		return false;
	}

	function ico_download($href,$name,$saveTo){
		return "<a download='{$saveTo}' href='{$href}' class='btn btn-primary btn-xs'><i class='fas fa-cloud-download'></i> {$name}</a>";
	}

	function get_name_link($link){
		return substr($link,strrpos($link,'/')+1);
	}

	function get_admins_status($id){
		$estado = ($id) ? 'Super Admin' : 'Admin Común';

		if($id) return '<a role="button" class="btn btn-xs btn-link" data-toggle="tooltip" data-placement="top" title="'.$estado.'">
						<i class="fas fa-user-plus fa-lg text-success"></i></a>';

		return '<a role="button" class="btn btn-xs btn-link" data-toggle="tooltip" data-placement="top" title="'.$estado.'">
				<i class="fas fa-user-times fa-lg text-danger"></i></a>';
	}

	function get_status_reset_password($id){
		$estado = ($id) ? 'Esperando nueva password' : '';
		return ($id) ? '<i class="fas fa-key"></i> "'.$estado.'"' : '';
	}

	function get_status_icon($id){
		$estado = ($id) ? 'Activo' : 'Inactivo';
		if($id){
			return '<a role="button" class="btn btn-xs btn-link" data-toggle="tooltip" data-placement="top" title="'.$estado.'">
					<i class="fas fa-check-circle fa-lg text-success"></i></a>';
		}
		return '<a role="button" class="btn btn-xs btn-link" data-toggle="tooltip" data-placement="top" title="'.$estado.'">
				<i class="fas fa-times-circle fa-lg text-danger"></i></a>';
	}

	function HavePerm($b1, $b2){
		return (( (int) $b1 & (int) $b2) == 0) ? false : true;
	}

	function ChekPerms($perm_key,$id){

		return true;

		if(isset($_SESSION['user']['admin_mega']) && $_SESSION['user']['admin_mega'] == 1){
			return true;
		}

		$users = new rs();
		$users->table = 'admins';
		$users->primary_key = 'admin_id';

		$sql = new rs();
		$sql->table = 'perm_types';
		$sql->primary_key = 'perm_type_key';
		//$sql->debug=true;

		if(!$sql->get($perm_key)){
			return false;
		}

		if(!$users->get($id)){
			return false;
		}

		if(!HavePerm($users->admin_access, $sql->perm_type_value)){
			return false;
		}

		return true;
	}

	function valida_nif_cif_nie($cif) {

		//Los valores devueltos son:
		//Tipo:	       ???	NIF	CIF	NIE
		//Correcto:		     1 	 2   3
		//Incorrecto:	0  	-1  -2 	-3

		//Copyright ©2005-2011 David Vidal Serra. Bajo licencia GNU GPL.
		//Este software viene SIN NINGUN TIPO DE GARANTIA; para saber mas detalles
		//puede consultar la licencia en http://www.gnu.org/licenses/gpl.txt(1)
		//Esto es software libre, y puede ser usado y redistribuirdo de acuerdo
		//con la condicion de que el autor jamas sera responsable de su uso.
		//Returns: 1 = NIF ok, 2 = CIF ok, 3 = NIE ok, -1 = NIF bad, -2 = CIF bad, -3 = NIE bad, 0 = ??? bad

		$cif = strtoupper($cif);

		for ($i = 0; $i < 9; $i ++){
			$num[$i] = substr($cif, $i, 1);
		}

		//si no tiene un formato valido devuelve error

		if (!preg_match('/((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)/', $cif)){
			return 0;
		}

		//comprobacion de NIFs estandar

		if (preg_match('/(^[0-9]{8}[A-Z]{1}$)/', $cif)){

			if ($num[8] == substr('TRWAGMYFPDXBNJZSQVHLCKE', substr($cif, 0, 8) % 23, 1)){
				return 1;
			}else{
				return -1;
			}
		}

		//algoritmo para comprobacion de codigos tipo CIF

		$suma = $num[2] + $num[4] + $num[6];

		for ($i = 1; $i < 8; $i += 2){
			$suma += substr((2 * $num[$i]),0,1) + substr((2 * $num[$i]), 1, 1);
		}

		$n = 10 - substr($suma, strlen($suma) - 1, 1);

		//comprobacion de NIFs especiales (se calculan como CIFs o como NIFs)

		if (preg_match('/^[KLM]{1}/', $cif)){

			if ($num[8] == chr(64 + $n) || $num[8] == substr('TRWAGMYFPDXBNJZSQVHLCKE', substr($cif, 1, 8) % 23, 1)){
				return 1;
			}else{
				return -1;
			}
		}

		//comprobacion de CIFs

		if (preg_match('/^[ABCDEFGHJNPQRSUVW]{1}/', $cif)){

			if ($num[8] == chr(64 + $n) || $num[8] == substr($n, strlen($n) - 1, 1)){
				return 2;
			}else{
				return -2;
			}
		}

		//comprobacion de NIEs

		if (preg_match('/^[XYZ]{1}/', $cif)){

			if ($num[8] == substr('TRWAGMYFPDXBNJZSQVHLCKE', substr(str_replace(array('X','Y','Z'), array('0','1','2'), $cif), 0, 8) % 23, 1)){
				return 3;
			}else{
				return -3;
			}
		}

		//si todavia no se ha verificado devuelve error
		return 0;

	}

	function human_filesize($bytes, $decimals = 2) {
		$sz = 'BKMGTP';
		$factor = floor((strlen($bytes) - 1) / 3);
		return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
	}

	function convertFileSize($file, $size=null, $decimals=2, $dec_sep='.', $thousands_sep=','){
		if (!is_file($file)){
			return "El fichero no existe";
		}
		$bytes = filesize($file);
		$sizes = 'BKMGTP';
		if (isset($size)){
			$factor = strpos($sizes, $size[0]);
			if ($factor===false){
				return "El tamaño debe ser B, K, M, G, T o P";
			}
		} else {
			$factor = floor((strlen($bytes) - 1) / 3);
			$size = $sizes[$factor];
		}
		return number_format($bytes / pow(1024, $factor), $decimals, $dec_sep, $thousands_sep).' '.$size;
	}

	function RealFileSize($fp){
		$pos = 0;
		$size = 1073741824;
		fseek($fp, 0, SEEK_SET);
		while ($size > 1)
		{
			fseek($fp, $size, SEEK_CUR);

			if (fgetc($fp) === false)
			{
				fseek($fp, -$size, SEEK_CUR);
				$size = (int)($size / 2);
			}
			else
			{
				fseek($fp, -1, SEEK_CUR);
				$pos += $size;
			}
		}

		while (fgetc($fp) !== false)  $pos++;

		return $pos;
	}

	function porcentaje($cantidad,$porciento,$decimales=2){
		return number_format($cantidad*$porciento/100 ,$decimales);
	}

	function encrypt($data, $secret){
		//Generate a key from a hash
		$key = md5(utf8_encode($secret), true);
		//Take first 8 bytes of $key and append them to the end of $key.
		$key .= substr($key, 0, 8);
		//Pad for PKCS7
		$blockSize = mcrypt_get_block_size('tripledes', 'ecb');
		$len = strlen($data);
		$pad = $blockSize - ($len % $blockSize);
		$data .= str_repeat(chr($pad), $pad);
		//Encrypt data
		$encData = mcrypt_encrypt('tripledes', $key, $data, 'ecb');
		return base64_encode($encData);
	}

	function decrypt($data, $secret){
		//Generate a key from a hash
		$key = md5(utf8_encode($secret), true);
		//Take first 8 bytes of $key and append them to the end of $key.
		$key .= substr($key, 0, 8);
		$data = base64_decode($data);
		$data = mcrypt_decrypt('tripledes', $key, $data, 'ecb');
		$block = mcrypt_get_block_size('tripledes', 'ecb');
		$len = strlen($data);
		$pad = ord($data[$len-1]);
		return substr($data, 0, strlen($data) - $pad);
	}

	function SpanishToEnglish($date){
		if($date){
			$date = explode("/", $date);
			$fecha = new DateTime();
			$fecha->setDate($date[2], $date[1], $date[0]);
			return $fecha->format('Y-m-d');
		}
		return "";
	}

	/**
	 * determina el tamaño de archivos y directorios
	 * @param $path
	 * @param string $formated
	 * @param $retstring
	 * @return boolean|string
	 */
	function _size($path, $formated = true, $retstring = null){

		if(!is_dir($path) || !is_readable($path)){

			if(is_file($path) || file_exists($path)){

				$size = filesize($path);

			} else {

				return false;
			}

		} else {

			$path_stack[] = $path;
			$size = 0;

			do {

				$path	= array_shift($path_stack);
				$handle	= opendir($path);

				while(false !== ($file = readdir($handle))) {

					if($file != '.' && $file != '..' && is_readable($path . DIRECTORY_SEPARATOR . $file)) {

						if(is_dir($path . DIRECTORY_SEPARATOR . $file)){

							$path_stack[] = $path . DIRECTORY_SEPARATOR . $file;
						}

						$size += filesize($path . DIRECTORY_SEPARATOR . $file);
					}
				}

				closedir($handle);

			}

			while (count($path_stack) > 0);

		}

		if($formated){

			$sizes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');

			if($retstring == null) {

				$retstring = '%01.2f %s';
			}

			$lastsizestring = end($sizes);

			foreach($sizes as $sizestring){

				if($size < 1024){
					break;
				}

				if($sizestring != $lastsizestring){

					$size /= 1024;
				}
			}

			if($sizestring == $sizes[0]){

				$retstring = '%01d %s';
			}
			// los Bytes normalmente no son fraccionales

			$size = sprintf($retstring, $size, $sizestring);
		}

		return $size;
	}
?>