<?php
/**
 * Main
 *
 * @author El pelado
 * @package Pakete loco
 *
 */

	ob_start();

	error_reporting(E_ALL);
	ini_set("display_errors", 0);

	session_cache_limiter('private');
	session_cache_expire(420);
	session_set_cookie_params(28800);

	ini_set("session.cookie_lifetime", 0);
	ini_set("session.gc_maxlifetime", 28800);
	ini_set("session.use_cookies", 1);
	ini_set("session.use_only_cookies", 1);
	ini_set("session.use_trans_sid", 0);
	ini_set("upload_max_filesize",1.5e+7);
	ini_set("post_max_size",1.5e+7);
	ini_set("max_execution_time", 300);
	ini_set("max_input_time", 0);
	ini_set("memory_limit", "128M");

	session_start();

	$time_start  = microtime(true);

	if(PHP_VERSION >= 5){
		date_default_timezone_set('America/Montevideo');
	}

	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache");
	header("Cache-Control: max-age=2592000");

	/**
	 * Base Path
	 */
	define('BASE_PATH', realpath(dirname(realpath(__FILE__))));

	/**
	 * Includes Path
	 */
	define('INCLUDE_PATH', BASE_PATH . "/includes/");

	/**
	 * Set Inludes
	 */
	set_include_path(INCLUDE_PATH);

	$templates_email      = "/templates_email/";
	$templates_path       = '/templates/';
	$templates_cache_path = '/temp/template_cache/';

	/**
	 *
	 * @var Includes Clases
	 */
	define('CLASS_PATH', INCLUDE_PATH . 'classes/');

	/**
	 *  Templates Path
	 */
	define('TEMPLATES_PATH', BASE_PATH . $templates_path);

	/**
	 * Templates Cache Path
	 */
	define('TEMPLATES_CACHE_PATH', BASE_PATH . $templates_cache_path);

	/**
	 *  Templates Path Email
	 */
	define('TEMPLATES_EMAIL', BASE_PATH . $templates_email);

	/**
	 * Config
	 */
	require_once(INCLUDE_PATH . 'config.inc.php');

	/**
	 * Config
	 */
	require_once(INCLUDE_PATH . 'setting.inc.php');

	/**
	 * Sigma Templates
	 */
	require_once(INCLUDE_PATH . 'sigma.inc.php');

	/**
	 * RS Class
	 */
	require_once(INCLUDE_PATH . 'rs.class.php');

	/**
	 * General Functions
	 */
	require_once(INCLUDE_PATH . 'functions.inc.php');

	/**
	 * Mail Class
	 */
	require_once(INCLUDE_PATH . 'phpmailer/PHPMailerAutoload.php');

	/**
	 * Security Class
	 */
	require_once(INCLUDE_PATH . 'security.class.php');

	/**
	 * recaptcha
	 */
	require_once(CLASS_PATH . 'recaptcha/autoload.php');

	register_shutdown_function( "check_for_fatal" );
	set_error_handler( "log_error" );
	set_exception_handler( "log_exception" );

	spl_autoload_register(function ($class_name) {
		if(file_exists(CLASS_PATH . strtolower($class_name) . '.class.php')){
			require_once(CLASS_PATH . strtolower($class_name) . '.class.php');
		}else {
			define("CLASS_NOT_FOUND", 'Class not found.');
		}
	});


	/**
	 * Default Values
	 */
	$page_title         = 'Crazy About Beauty';
	$page_keywords      = 'Crazy About Beauty';
	$page_description   = 'Crazy About Beauty';
	$page_author		= '3tipos.com';
	$layout             = true;
	$fechas             = false;

	/**
	 *
	 * @var nombre de la librearia js que se quiere levantar, solo el nombre sin extension .js
	 */
	$customslibs        = false;

?>
